IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_INTEGRACAO_ENVIO_PENDENTE]') AND type in (N'U'))
begin
	CREATE TABLE [dbo].[EST_PROD_INTEGRACAO_ENVIO_PENDENTE](
		[CD_EMP] [int] NOT NULL,
		[CD_PROD] [INT] NOT NULL,
		[DT_CAD] [datetime] NULL,
	 CONSTRAINT [PK_EST_PROD_INTEGRACAO_ENVIO_PENDENTE] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].EST_PROD_INTEGRACAO_ENVIO_PENDENTE ADD  CONSTRAINT [DF_EST_PROD_INTEGRACAO_ENVIO_PENDENTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].EST_PROD_INTEGRACAO_ENVIO_PENDENTE ADD  CONSTRAINT [DF_EST_PROD_INTEGRACAO_ENVIO_PENDENTE_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].EST_PROD_INTEGRACAO_ENVIO_PENDENTE  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_INTEGRACAO_ENVIO_PENDENTE_EST_PROD] FOREIGN KEY([CD_EMP],[CD_PROD])
	REFERENCES [dbo].[EST_PROD] ([CD_EMP],[CD_PROD])
	ON DELETE CASCADE

	ALTER TABLE [dbo].EST_PROD_INTEGRACAO_ENVIO_PENDENTE CHECK CONSTRAINT [FK_EST_PROD_INTEGRACAO_ENVIO_PENDENTE_EST_PROD]
end